<?php
/**
 * Podcast player toolkit page
 *
 * @package Podcast Player
 * @since 5.1.0
 */

use PP_Pro\Admin\Templates\Toolkit\Helper\Getters as Toolkit_Fn;
use PP_Pro\Helper\Functions\Getters as PP_Get_Fn;

$post_types = PP_Get_Fn::get_post_types();
$p_users    = get_users();
$p_status   = array(
	'publish' => esc_html__( 'Publish', 'podcast-player' ),
	'draft'   => esc_html__( 'Save as Draft', 'podcast-player' ),
);
$p_where    = array(
	''       => esc_html__( 'Show podcast audio player before post content', 'podcast-player' ),
	'after'  => esc_html__( 'Show podcast audio player after post content', 'podcast-player' ),
	'noshow' => esc_html__( 'Do not display podcast audio player', 'podcast-player' ),
);
$p_style    = array(
	''       => esc_html__( 'Default Player', 'podcast-player' ),
	'modern' => esc_html__( 'Modern Player', 'podcast-player' ),
	'legacy' => esc_html__( 'Catalogue (Legacy) Player', 'podcast-player' ),
	'lv1'    => esc_html__( 'List - Normal', 'pp-pro' ),
	'lv2'    => esc_html__( 'List - small', 'pp-pro' ),
	'lv3'    => esc_html__( 'List - Minimal', 'pp-pro' ),
	'lv4'    => esc_html__( 'List - Individual', 'pp-pro' ),
);
?>

<h3 class="pp-toolkit-title">Feed Import Tool</h3>
<div class="pp-toolkit-content">
	<div class="pp-notice-info"><?php esc_html_e( 'This tool will help to import podcast episodes into WordPress posts (or any post type).', 'podcast-player' ); ?></div>
	<?php if ( $feed_index && is_array( $feed_index ) ) : ?>
		<?php
		$feed_index = array_merge(
			$feed_index,
			array( '' => esc_html__( 'Select a Podcast to Import', 'podcast-player' ) )
		);
		?>
		<select id="pp-feed-import-index" name="pp-feed-index" class="select-pp-feed-import-index">
			<?php
			foreach ( $feed_index as $key => $label ) {
				if ( is_array( $label ) ) {
					$label = isset( $label['title'] ) ? $label['title'] : '';
				}
				echo '<option value="' . esc_attr( $key ) . '">' . esc_html( $label ) . '</option>';
			}
			?>
		</select>
		<h4 class="pp-index-optional" style="padding: 0 20px;"><?php esc_html_e( 'OR', 'podcast-player' ); ?></h4>
	<?php endif; ?>
	<div class="feed-import-url">
		<label class="label-feed-import">
			<input class="pp-toolkit-url" type="url" placeholder="Enter Your Podcast Feed URL" title="Feed Editor">
		</label>
		<button class="button feed-url-import-btn"><span class="dashicons dashicons-editor-break"></span></button>
	</div>
	<div id="pp-import-tabs-container">
		<ul class="pp-import-tabs">
			<li class="pp-import-tabs-item toolkit-importer active"><?php esc_html_e( 'Episodes to be imported', 'podcast-player' ); ?></li>
			<li class="pp-import-tabs-item toolkit-imported"><?php esc_html_e( 'Episodes already imported', 'podcast-player' ); ?></li>
		</ul>
	</div>
	<div id="pp-import-container">
		<div class="pp-toolkit-importer"></div>
		<div class="pp-toolkit-import-options">
			<fieldset>
				<legend><?php esc_html_e( 'Import Options', 'podcast-player' ); ?></legend>
				<table class="form-table" role="presentation">
					<tbody>
						<tr>
							<th scope="row" class="pp-toolkit-op-title">
								<span class="pp-opt-desc">Download Episode's Featured Image from the Feed (If any)</span>
							</th>
							<td class="pp-toolkit-op-input">
								<label class="switch">
									<input class="pp-import-featured" type="checkbox" title="Import Featured Image" value="yes" ?> >
									<div class="slider"></div>
								</label>
							</td>
						</tr>
					</tbody>
				</table>
				<?php if ( $post_types && is_array( $post_types ) ) : ?>
					<span style="margin-bottom: 5px;display: block;"><?php esc_html_e( 'Post Type', 'podcast-player' ); ?></span>
					<select id="pp-import-post-types" name="pp-import-post-types" class="select-pp-import-post-types">
						<?php
						foreach ( $post_types as $key => $label ) {
							echo '<option value="' . esc_attr( $key ) . '">' . esc_html( $label ) . '</option>';
						}
						?>
					</select>
				<?php endif; ?>
				<span style="margin-bottom: 5px;display: block;"><?php esc_html_e( 'Post Status', 'podcast-player' ); ?></span>
				<select id="pp-import-post-status" name="pp-import-post-status" class="select-pp-import-post-status">
					<?php
					foreach ( $p_status as $key => $label ) {
						echo '<option value="' . esc_attr( $key ) . '">' . esc_html( $label ) . '</option>';
					}
					?>
				</select>
				<?php if ( $p_users && count( $p_users ) > 1 ) : ?>
					<span style="margin-bottom: 5px;display: block;"><?php esc_html_e( 'Default Post Author', 'podcast-player' ); ?></span>
					<?php
					wp_dropdown_users(
						array(
							'name'  => 'pp-import-author',
							'class' => 'select-pp-import-author',
						)
					);
					?>
				<?php endif; ?>
			</fieldset>
			<fieldset>
				<legend><?php esc_html_e( 'Player Options', 'podcast-player' ); ?></legend>
				<p style="font-size: 14px; font-style: italic;"><?php esc_html_e( 'Episode\'s audio will not be downloaded on this website. URL of audio with your podcast host will be used to display the player.', 'podcast-player' ); ?></p>
				<div class="import-where ppa-import-settings">
					<span style="margin-bottom: 5px;display: block;"><?php esc_html_e( 'Where to display the single audio player?', 'podcast-player' ); ?></span>
					<?php Toolkit_Fn::select( 'ppa-import-where', $p_where, '', array(), true ); ?>
				</div>
				<div class="pp-import-player-options">
					<div class="import-style ppa-import-settings">
						<span style="margin-bottom: 5px;display: block;"><?php esc_html_e( 'Choose Player Display Style', 'podcast-player' ); ?></span>
						<?php Toolkit_Fn::select( 'ppa-import-style', $p_style, '', array(), true ); ?>
					</div>
					<table class="form-table" role="presentation">
						<tbody>
							<tr>
								<th scope="row" class="pp-toolkit-op-title">
									<span class="pp-opt-title">Player Background Color.</span>
									<span class="pp-opt-desc">Setup audio player's background color.</span>
								</th>
								<td class="pp-toolkit-op-input"><input class="pp-import-bg-color pp-color-picker" type="text" title="Setup Background Color" value=""></td>
							</tr>
							<tr>
								<th scope="row" class="pp-toolkit-op-title">
									<span class="pp-opt-title">Player Acccent Color.</span>
									<span class="pp-opt-desc">Setup audio player's accent color (Button, links etc.)</span>
								</th>
								<td class="pp-toolkit-op-input"><input class="pp-import-accent-color pp-color-picker" type="text" title="Setup Accent Color" value=""></td>
							</tr>
							<tr>
								<th scope="row" class="pp-toolkit-op-title">
									<span class="pp-opt-desc">Hide Social Sharing Options</span>
								</th>
								<td class="pp-toolkit-op-input">
									<label class="switch">
										<input class="pp-import-social-sharing" type="checkbox" title="Hide Social Sharing" value="yes">
										<div class="slider"></div>
									</label>
								</td>
							</tr>
							<tr>
								<th scope="row" class="pp-toolkit-op-title">
									<span class="pp-opt-desc">Hide Episode Download Option</span>
								</th>
								<td class="pp-toolkit-op-input">
									<label class="switch">
										<input class="pp-import-download" type="checkbox" title="Hide Episode Download" value="yes">
										<div class="slider"></div>
									</label>
								</td>
							</tr>
							<tr>
								<th scope="row" class="pp-toolkit-op-title">
									<span class="pp-opt-desc">Hide Episode Title</span>
								</th>
								<td class="pp-toolkit-op-input">
									<label class="switch">
										<input class="pp-import-title" type="checkbox" title="Hide Episode Title" value="yes">
										<div class="slider"></div>
									</label>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</fieldset>
		</div>
		<button class="pp-toolkit-buttons pp-import-podcast-btn button">
			<span class="dashicons dashicons-download"></span>
			<span class="pp-toolkit-btn-text">Import Episodes</span>
		</button>
		<button class="pp-toolkit-buttons pp-import-abort-btn button">
			<span class="pp-toolkit-btn-text">Abort Import</span>
		</button>
	</div>
	<div id="pp-imported-container">
		<div class="pp-toolkit-imported"></div>
		<button class="pp-toolkit-buttons pp-imported-podcast-btn button">
			<span class="dashicons dashicons-trash"></span>
			<span class="pp-toolkit-btn-text">Delete</span>
		</button>
	</div>
	<div class="pp-toolkit-feedback">
		<span class="dashicons dashicons-update"></span>
		<span class="dashicons dashicons-yes"></span>
		<span class="dashicons dashicons-no"></span>
		<span class="pp-feedback"></span>
	</div>
	<div id="pp-import-progress">
		<div id="pp-import-progress-bar" data-width="0"></div>
	</div>
</div>
