<?php
/**
 * Podcast player toolkit page
 *
 * @package Podcast Player
 * @since 3.3.0
 */

use Podcast_Player\Helper\Functions\Getters as Get_Fn;
use Podcast_Player\Helper\Functions\Validation as Validation_Fn;

$fmethod = isset( $sticky_pl['fmethod'] ) ? esc_attr( $sticky_pl['fmethod'] ) : '';
?>

<h3 class="pp-toolkit-title">Sticky Player Tool</h3>
<div class="pp-toolkit-content">
	<div class="pp-notice-info"><?php esc_html_e( 'A convenient tool to display a bottom sticky player on all the pages of your website.', 'podcast-player' ); ?></div>
	<?php
	$fetch_method = array(
		'feed' => esc_html__( 'From Feed', 'podcast-player' ),
		'post' => esc_html__( 'From Posts', 'podcast-player' ),
		'link' => esc_html__( 'From Single Audio URL', 'podcast-player' ),
	);
	?>
	<div class="pp-fetch">
		<span style="margin-bottom: 5px;display: block;"><?php esc_html_e( 'From where to fetch your podcast?', 'podcast-player' ); ?></span>
		<select id="pp-feed-method" name="pp-feed-method" class="select-pp-feed-method">
			<?php
			foreach ( $fetch_method as $key => $label ) {
				if ( is_array( $label ) ) {
					$label = isset( $label['title'] ) ? $label['title'] : '';
				}
				echo '<option value="' . esc_attr( $key ) . '" ' . selected( $key, $fmethod, false ) . '>' . esc_html( $label ) . '</option>';
			}
			?>
		</select>
	</div>
	<?php require PP_PRO_DIR . '/admin/templates/toolkit/parts/fetch-feed.php'; ?>
	<?php require PP_PRO_DIR . '/admin/templates/toolkit/parts/fetch-posts.php'; ?>
	<?php require PP_PRO_DIR . '/admin/templates/toolkit/parts/fetch-audio.php'; ?>
	<div class="pp-sticky-settings">
		<?php
		$sticky_accent = '';
		$sticky_bg     = '';
		$sticky_ss     = '';
		$sticky_dl     = '';
		if ( isset( $sticky_pl['accent'] ) ) {
			$sticky_accent = esc_attr( sanitize_hex_color( $sticky_pl['accent'] ) );
		}
		if ( isset( $sticky_pl['bg'] ) ) {
			$sticky_bg = esc_attr( sanitize_hex_color( $sticky_pl['bg'] ) );
		}
		if ( isset( $sticky_pl['share'] ) ) {
			$sticky_ss = esc_attr( $sticky_pl['share'] );
		}
		if ( isset( $sticky_pl['dl'] ) ) {
			$sticky_dl = esc_attr( $sticky_pl['dl'] );
		}
		?>
		<table class="form-table" role="presentation">
			<tbody>
				<tr>
					<th scope="row" class="pp-toolkit-op-title">
						<span class="pp-opt-title">Player Background Color.</span>
						<span class="pp-opt-desc">Setup sticky player's background color.</span>
					</th>
					<td class="pp-toolkit-op-input"><input class="pp-bg-color pp-color-picker" type="text" title="Setup Background Color" value="<?php echo $sticky_bg; ?>"></td>
				</tr>
				<tr>
					<th scope="row" class="pp-toolkit-op-title">
						<span class="pp-opt-title">Player Acccent Color.</span>
						<span class="pp-opt-desc">Setup sticky player's accent color (Button, links etc.)</span>
					</th>
					<td class="pp-toolkit-op-input"><input class="pp-accent-color pp-color-picker" type="text" title="Setup Accent Color" value="<?php echo $sticky_accent; ?>"></td>
				</tr>
				<tr>
					<th scope="row" class="pp-toolkit-op-title">
						<span class="pp-opt-desc">Hide Social Sharing Options</span>
					</th>
					<td class="pp-toolkit-op-input">
						<label class="switch">
						<input class="pp-social-sharing" type="checkbox" title="Hide Social Sharing" value="yes" <?php checked( $sticky_ss, 'yes' ); ?> >
						<div class="slider"></div>
						</label>
					</td>
				</tr>
				<tr>
					<th scope="row" class="pp-toolkit-op-title">
						<span class="pp-opt-desc">Hide Episode Download Option</span>
					</th>
					<td class="pp-toolkit-op-input">
						<label class="switch">
						<input class="pp-download" type="checkbox" title="Hide Episode Download" value="yes" <?php checked( $sticky_dl, 'yes' ); ?> >
						<div class="slider"></div>
						</label>
					</td>
				</tr>
			</tbody>
		</table>
	</div>
	<button class="pp-toolkit-buttons pp-feed-sticky button">
		<span class="dashicons dashicons-plus-alt2"></span>
		<span class="pp-toolkit-btn-text">Add Sticky Player</span>
	</button>
	<button class="pp-toolkit-buttons pp-remove-sticky button">
		<span class="dashicons dashicons-trash"></span>
		<span class="pp-toolkit-btn-text">Remove Sticky Player</span>
	</button>
	<div class="pp-toolkit-feedback">
		<span class="dashicons dashicons-update"></span>
		<span class="dashicons dashicons-no"></span>
		<span class="dashicons dashicons-yes"></span>
		<span class="pp-feedback"></span>
	</div>
</div>
