<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin
 * and defines a function that starts the plugin.
 *
 * @link              https://www.vedathemes.com
 * @since             1.0.0
 * @package           pp-pro
 *
 * @wordpress-plugin
 * Plugin Name:       podcast player pro
 * Plugin URI:        https://vedathemes.com/podcast-player/
 * Description:       Podcast Player Pro Plugin.
 * Version:           3.7.0
 * Author:            vedathemes
 * Author URI:        https://www.vedathemes.com
 * License:           GPL-3.0+
 * License URI:       http://www.gnu.org/licenses/gpl-3.0.txt
 * Text Domain:       pp-pro
 * Domain Path:       /lang
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

// Currently plugin version.
define( 'PP_REQUIRED', '5.3.0' );

// Currently plugin version.
define( 'PP_PRO_VERSION', '3.7.0' );

// Define plugin constants.
define( 'PP_PRO_DIR', plugin_dir_path( __FILE__ ) );

// Define plugin constants.
define( 'PP_PRO_URL', plugin_dir_url( __FILE__ ) );

// Store URL.
define( 'PP_PRO_STORE_URL', 'https://vedathemes.com' );

// Download ID.
define( 'PP_PRO_ITEM_ID', 644 );

// Register PHP autoloader.
spl_autoload_register(
	function( $class ) {
		$namespace = 'PP_Pro\\';

		// Bail if the class is not in our namespace.
		if ( 0 !== strpos( $class, $namespace ) ) {
			return;
		}

		// Get classname without namespace.
		$carray = array_values( explode( '\\', $class ) );
		$clast  = count( $carray ) - 1;

		// Return if proper array is not available. (Just in case).
		if ( ! $clast ) {
			return;
		}

		// Prefix the classname with 'class-'.
		$carray[ $clast ] = 'class-' . $carray[ $clast ];
		$class            = implode( '\\', $carray );

		// Generate file path from classname.
		$path = strtolower(
			str_replace(
				array( $namespace, '_' ),
				array( '', '-' ),
				$class
			)
		);

		// Build full filepath.
		$file = PP_PRO_DIR . DIRECTORY_SEPARATOR . str_replace( '\\', DIRECTORY_SEPARATOR, $path ) . '.php';

		// If the file exists for the class name, load it.
		if ( file_exists( $file ) ) {
			include $file;
		}
	}
);

/**
 * Load Podcast Player Pro.
 *
 * @since 1.0.0
 */
function pp_pro_plugins_loaded() {
	if (
		defined( 'PODCAST_PLAYER_VERSION' ) &&
		version_compare( PODCAST_PLAYER_VERSION, PP_REQUIRED, '>=' )
	) {
		// Loads a plugin’s translated strings.
		load_plugin_textdomain( 'pp-pro', false, PP_PRO_DIR . 'lang/' );

		// Register Podcast player Pro functionality.
		PP_Pro\Inc\Register::init();
	} else {

		// Show admin notice that podcast player free is not installed.
		add_action( 'admin_notices', 'pp_pro_admin_notices' );
	}
}
add_action( 'plugins_loaded', 'pp_pro_plugins_loaded' );

/**
 * Display Admin notice if Podcast Player Free Version is not installed or activated.
 *
 * @since 1.0.0
 */
function pp_pro_admin_notices() {

	// Check what admin page we are on.
	$current_screen = get_current_screen();

	if ( 'plugins' !== $current_screen->id && 'plugins' !== $current_screen->parent_file ) {
		return;
	}

	$link1 = '';
	$link2 = '';
	if ( current_user_can( 'install_plugins' ) ) {
		$url   = add_query_arg(
			array(
				'tab'       => 'plugin-information',
				'plugin'    => 'podcast-player',
				'TB_iframe' => 'true',
				'width'     => '640',
				'height'    => '500',
			),
			network_admin_url( 'plugin-install.php' )
		);
		$link1 = sprintf(
			'<a class="thickbox open-plugin-details-modal" href="%1$s">%2$s</a>',
			esc_url( $url ),
			esc_html__( 'Install Now', 'pp-pro' )
		);

		$link2 = sprintf(
			'<a class="thickbox open-plugin-details-modal" href="%1$s">%2$s</a>',
			esc_url( $url ),
			esc_html__( 'Update Now', 'pp-pro' )
		);
	}

	$icon = sprintf( '<span class="pp-notice-icon dashicons dashicons-info" style="display: inline-block;margin-right: 5px; color: #dc3232;"></span>' );

	if ( ! defined( 'PODCAST_PLAYER_VERSION' ) ) {
		printf(
			'<div class="notice is-dismissible notice-warning">
				<p>%1$s %2$s %3$s</p>
			</div>',
			$icon, // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			esc_html__( 'PP Pro requires Podcast Player free version to be installed & activated.', 'pp-pro' ),
			$link1 // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		);
	} elseif ( version_compare( PODCAST_PLAYER_VERSION, PP_REQUIRED, '<' ) ) {
		printf(
			'<div class="notice is-dismissible notice-warning">
				<p>%1$s %2$s %3$s. %4$s</p>
			</div>',
			$icon, // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			esc_html__( 'PP Pro requires minimum Podcast Player version to be', 'pp-pro' ),
			esc_html( PP_REQUIRED ),
			$link2 // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		);
	}
}

/**
 * Add plugin action links.
 *
 * Add a link to the settings page on the plugins.php page.
 *
 * @since 1.0.0
 *
 * @param  array $links List of existing plugin action links.
 * @return array         List of modified plugin action links.
 */
function pp_pro_action_links( $links ) {
	if ( ! defined( 'PODCAST_PLAYER_VERSION' ) ) {
		return $links;
	}
	$status = get_option( 'pp_pro_license_status' );
	if ( false !== $status && 'valid' === $status ) {
		return $links;
	}
	$links = array_merge(
		array(
			'<a href="' . esc_url( admin_url( 'admin.php?page=pp-options' ) ) . '" style="color: #35b747; font-weight: 700;">' . __( 'License Activation', 'pp-pro' ) . '</a>',
		),
		$links
	);
	return $links;
}
add_action( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'pp_pro_action_links' );

// Load PP Pro plugin update file.
require_once PP_PRO_DIR . '/admin/update-init.php';
