<?php

namespace DevOwl\RealCookieBanner\lite\presets;

use DevOwl\RealCookieBanner\comp\language\Hooks;
use DevOwl\RealCookieBanner\presets\pro\CloudflarePreset as ProCloudflarePreset;
use DevOwl\RealCookieBanner\Utils;
// @codeCoverageIgnoreStart
\defined('ABSPATH') or die('No script kiddies please!');
// Avoid direct file request
// @codeCoverageIgnoreEnd
/**
 * Cloudflare cookie preset.
 */
class CloudflarePreset extends \DevOwl\RealCookieBanner\presets\pro\CloudflarePreset {
    // Documented in AbstractPreset
    public function common() {
        $parent = parent::common();
        $cookieHost = \DevOwl\RealCookieBanner\Utils::host(
            \DevOwl\RealCookieBanner\Utils::HOST_TYPE_MAIN_WITH_ALL_SUBDOMAINS
        );
        return \array_merge($parent, [
            'attributes' => [
                'name' => $parent['name'],
                'group' => __('Essential', \DevOwl\RealCookieBanner\comp\language\Hooks::TD_FORCED),
                'purpose' => __(
                    'Cloudflare protects websites from malicious traffic and stores parts of the website in the cache for faster delivery. Cloudflare can also deliver a cached version of the website if the server of the website is unavailable. The cookies are used to uniquely identify the user and classify him or her as a potential attacker and to determine the fastest available server.',
                    \DevOwl\RealCookieBanner\comp\language\Hooks::TD_FORCED
                ),
                'provider' => 'Cloudflare Inc.',
                'providerPrivacyPolicy' => 'https://www.cloudflare.com/privacypolicy/',
                'technicalDefinitions' => [
                    [
                        'type' => 'http',
                        'name' => '_cflb',
                        'host' => $cookieHost,
                        'durationUnit' => 'y',
                        'sessionDuration' => \true,
                        'duration' => 0
                    ],
                    [
                        'type' => 'http',
                        'name' => '_cf_bm',
                        'host' => $cookieHost,
                        'duration' => 30,
                        'durationUnit' => 'm',
                        'sessionDuration' => \false
                    ],
                    [
                        'type' => 'http',
                        'name' => 'cf_ob_info',
                        'host' => $cookieHost,
                        'duration' => 1,
                        'durationUnit' => 'm',
                        'sessionDuration' => \false
                    ],
                    [
                        'type' => 'http',
                        'name' => 'cf_use_ob',
                        'host' => $cookieHost,
                        'duration' => 1,
                        'durationUnit' => 'm',
                        'sessionDuration' => \false
                    ],
                    [
                        'type' => 'http',
                        'name' => '__cfwaitingroom',
                        'host' => $cookieHost,
                        'duration' => 1,
                        'durationUnit' => 'd',
                        'sessionDuration' => \false
                    ]
                ],
                'codeOptOutDelete' => \false,
                'ePrivacyUSA' => \true
            ]
        ]);
    }
    // Documented in AbstractPreset
    public function managerNone() {
        return \false;
    }
    // Documented in AbstractPreset
    public function managerGtm() {
        return \false;
    }
    // Documented in AbstractPreset
    public function managerMtm() {
        return \false;
    }
}
