<?php

namespace DevOwl\RealCookieBanner\lite\presets;

use DevOwl\RealCookieBanner\presets\pro\FacebookForWooCommercePreset as ProFacebookForWooCommercePreset;
// @codeCoverageIgnoreStart
\defined('ABSPATH') or die('No script kiddies please!');
// Avoid direct file request
// @codeCoverageIgnoreEnd
/**
 * Facebook For WooCommerce preset -> Facebook Pixel cookie preset.
 */
class FacebookForWooCommercePreset extends \DevOwl\RealCookieBanner\presets\pro\FacebookForWooCommercePreset {
    // Documented in AbstractPreset
    public function common() {
        $parent = parent::common();
        return \array_merge($parent, [
            'attributes' => [
                'extends' => \DevOwl\RealCookieBanner\lite\presets\FacebookPixelPreset::IDENTIFIER,
                'disableTechnicalHandlingThroughPlugin' => [self::SLUG],
                'technicalHandlingNotice' => null
            ]
        ]);
    }
    // Documented in AbstractPreset
    public function managerNone() {
        return \false;
    }
    // Documented in AbstractPreset
    public function managerGtm() {
        return \false;
    }
    // Documented in AbstractPreset
    public function managerMtm() {
        return \false;
    }
}
