<?php

namespace DevOwl\RealCookieBanner\lite\presets;

use DevOwl\RealCookieBanner\comp\language\Hooks;
use DevOwl\RealCookieBanner\presets\pro\FacebookPagePluginPreset as ProFacebookPagePluginPreset;
// @codeCoverageIgnoreStart
\defined('ABSPATH') or die('No script kiddies please!');
// Avoid direct file request
// @codeCoverageIgnoreEnd
/**
 * Facebook Page Plugin cookie preset.
 */
class FacebookPagePluginPreset extends \DevOwl\RealCookieBanner\presets\pro\FacebookPagePluginPreset {
    // Documented in AbstractPreset
    public function common() {
        $parent = parent::common();
        return \array_merge($parent, [
            'attributes' => [
                'name' => $parent['name'],
                'group' => __('Marketing', \DevOwl\RealCookieBanner\comp\language\Hooks::TD_FORCED),
                'purpose' => __(
                    'Facebook Page Plugin shows information about a specific Facebook fan page that the visitor of this website may like. The cookies are used to collect likes content as well as to collect visited websites. This data can be linked to the data of users registered on facebook.com with their Facebook accounts.',
                    \DevOwl\RealCookieBanner\comp\language\Hooks::TD_FORCED
                ),
                'provider' => 'Facebook Ireland Ltd.',
                'providerPrivacyPolicy' => 'https://www.facebook.com/about/privacy',
                'technicalDefinitions' => [],
                'codeOptOutDelete' => \false,
                'codeOptIn' =>
                    '<div id="fb-root"></div>
<script async defer crossorigin="anonymous" src="https://connect.facebook.net/en_US/sdk.js#xfbml=1&version=v8.0" nonce="' .
                    \DevOwl\RealCookieBanner\lite\presets\FacebookLikePreset::createScriptNonce() .
                    '"></script>',
                'technicalHandlingNotice' => __(
                    'The default opt-in script is optimized for the use of the Facebook Page Plugin via the Facebook JavaScript SDK in the opt-in script. If you use the Facebook Page Plugin as an iframe or have already injected the Facebook SDK somewhere else (e. g. via a plugin), you must create a content blocker to block it before you have the consent of the user and delete the default opt-in script below.',
                    RCB_TD
                ),
                'ePrivacyUSA' => \true
            ]
        ]);
    }
    // Documented in AbstractPreset
    public function managerNone() {
        return \false;
    }
    // Documented in AbstractPreset
    public function managerGtm() {
        return \false;
    }
    // Documented in AbstractPreset
    public function managerMtm() {
        return \false;
    }
}
