<?php

namespace DevOwl\RealCookieBanner\lite\presets;

use DevOwl\RealCookieBanner\comp\language\Hooks;
use DevOwl\RealCookieBanner\presets\middleware\DisablePresetByNeedsMiddleware;
use DevOwl\RealCookieBanner\presets\pro\YandexMetricaPreset as ProYandexMetricaPreset;
use DevOwl\RealCookieBanner\Utils;
use DevOwl\RealCookieBanner\view\Banner;
// @codeCoverageIgnoreStart
\defined('ABSPATH') or die('No script kiddies please!');
// Avoid direct file request
// @codeCoverageIgnoreEnd
/**
 * Yandex Metrica cookie preset.
 */
class YandexMetricaPreset extends \DevOwl\RealCookieBanner\presets\pro\YandexMetricaPreset {
    const POTENTIAL_SKIP_IF_ACTIVE_PLUGINS = [
        // Free plugins
        'yandex-metrica'
    ];
    // Documented in AbstractPreset
    public function common() {
        $parent = parent::common();
        $cookieHost = \DevOwl\RealCookieBanner\Utils::host(
            \DevOwl\RealCookieBanner\Utils::HOST_TYPE_MAIN_WITH_ALL_SUBDOMAINS
        );
        $cookieHostCurrent = \DevOwl\RealCookieBanner\Utils::host(\DevOwl\RealCookieBanner\Utils::HOST_TYPE_CURRENT);
        return \array_merge($parent, [
            'attributes' => [
                'name' => $parent['name'],
                'group' => __('Statistic', \DevOwl\RealCookieBanner\comp\language\Hooks::TD_FORCED),
                'purpose' => __(
                    'Yandex Metrica is a service for creating detailed statistics of user behavior on the website. The cookies are used to differentiate users, store campaign related information for and from the user and to link data from multiple page views. This data may be linked to data about users who have signed in to their Yandex account on yandex.com or a localised version of Yandex. In some cases, the collected data can also be used for ad targeting in the Yandex Advertising Network.',
                    \DevOwl\RealCookieBanner\comp\language\Hooks::TD_FORCED
                ),
                'provider' => 'YANDEX LLC',
                'providerPrivacyPolicy' => 'https://metrica.yandex.com/about/info/privacy-policy',
                'technicalDefinitions' => [
                    [
                        'type' => 'http',
                        'name' => 'ymex',
                        'host' => '.yandex.ru',
                        'durationUnit' => 'y',
                        'sessionDuration' => \false,
                        'duration' => 1
                    ],
                    [
                        'type' => 'http',
                        'name' => 'i',
                        'host' => '.yandex.ru',
                        'duration' => 10,
                        'durationUnit' => 'y',
                        'sessionDuration' => \false
                    ],
                    [
                        'type' => 'http',
                        'name' => 'yandexuid',
                        'host' => '.yandex.ru',
                        'duration' => 1,
                        'durationUnit' => 'y',
                        'sessionDuration' => \false
                    ],
                    [
                        'type' => 'http',
                        'name' => 'yabs-sid',
                        'host' => 'mc.yandex.ru',
                        'durationUnit' => 'y',
                        'sessionDuration' => \true,
                        'duration' => 0
                    ],
                    [
                        'type' => 'http',
                        'name' => '_ym_uid',
                        'host' => $cookieHost,
                        'duration' => 1,
                        'durationUnit' => 'y',
                        'sessionDuration' => \false
                    ],
                    [
                        'type' => 'http',
                        'name' => '_ym_isad',
                        'host' => $cookieHost,
                        'duration' => 1,
                        'durationUnit' => 'd',
                        'sessionDuration' => \false
                    ],
                    [
                        'type' => 'http',
                        'name' => '_ym_d',
                        'host' => $cookieHost,
                        'duration' => 1,
                        'durationUnit' => 'y',
                        'sessionDuration' => \false
                    ],
                    [
                        'type' => 'http',
                        'name' => 'yuidss',
                        'host' => '.yandex.ru',
                        'duration' => 1,
                        'durationUnit' => 'y',
                        'sessionDuration' => \false
                    ],
                    [
                        'type' => 'local',
                        'name' => '_ym*_reqNum',
                        'host' => $cookieHostCurrent,
                        'durationUnit' => 'y',
                        'sessionDuration' => \false,
                        'duration' => 0
                    ],
                    [
                        'type' => 'local',
                        'name' => '_ym*_il',
                        'host' => $cookieHostCurrent,
                        'durationUnit' => 'y',
                        'sessionDuration' => \false,
                        'duration' => 0
                    ],
                    [
                        'type' => 'local',
                        'name' => '_ym_uid',
                        'host' => $cookieHostCurrent,
                        'durationUnit' => 'y',
                        'sessionDuration' => \false,
                        'duration' => 0
                    ],
                    [
                        'type' => 'local',
                        'name' => '_ym*_lastHit',
                        'host' => $cookieHostCurrent,
                        'durationUnit' => 'y',
                        'sessionDuration' => \false,
                        'duration' => 0
                    ],
                    [
                        'type' => 'local',
                        'name' => '_ym*_lsid',
                        'host' => $cookieHostCurrent,
                        'durationUnit' => 'y',
                        'sessionDuration' => \false,
                        'duration' => 0
                    ],
                    [
                        'type' => 'local',
                        'name' => '_ym_retryReqs',
                        'host' => $cookieHostCurrent,
                        'durationUnit' => 'y',
                        'sessionDuration' => \false,
                        'duration' => 0
                    ]
                ],
                'technicalHandlingNotice' => __(
                    'If you already embed Yandex Metrica into your website via a plugin, please remove the following opt-in code and create a content blocker for this service instead.',
                    RCB_TD
                ),
                'dynamicFields' => [
                    'yandexMetricaTagId' => [
                        'label' => __('Yandex Metrica Tag ID', RCB_TD),
                        'expression' => '^\\d+$',
                        'invalidMessage' => __('Please provide a valid ID!', RCB_TD),
                        'example' => '376341751',
                        'hint' => \sprintf(
                            // translators:
                            __(
                                'You find your Yandex Metrica Tag ID in the <a href="%s" target="_blank">Yandex Metrica Tags list</a>.',
                                RCB_TD
                            ),
                            'https://metrica.yandex.com/list/'
                        )
                    ]
                ],
                'codeOptIn' => \sprintf(
                    '<script %1$s="%2$s">
(function(m,e,t,r,i,k,a){m[i]=m[i]||function(){(m[i].a=m[i].a||[]).push(arguments)};
m[i].l=1*new Date();k=e.createElement(t),a=e.getElementsByTagName(t)[0],k.async=1,k.src=r,a.parentNode.insertBefore(k,a)})
(window, document, "script", "https://mc.yandex.ru/metrika/tag.js", "ym");

ym({{yandexMetricaTagId}}, "init", {
     clickmap:true,
     trackLinks:true,
     accurateTrackBounce:true
});
</script>
<noscript %1$s="%2$s"><div><img src="https://mc.yandex.ru/watch/{{yandexMetricaTagId}}" style="position:absolute; left:-9999px;" alt="" /></div></noscript>',
                    \DevOwl\RealCookieBanner\view\Banner::HTML_ATTRIBUTE_SKIP_IF_ACTIVE,
                    \join(',', self::POTENTIAL_SKIP_IF_ACTIVE_PLUGINS)
                ),
                'codeOptOutDelete' => \true,
                'ePrivacyUSA' => \true,
                'deactivateAutomaticContentBlockerCreationByNeeds' => \DevOwl\RealCookieBanner\presets\middleware\DisablePresetByNeedsMiddleware::generateNeedsForSlugs(
                    self::POTENTIAL_SKIP_IF_ACTIVE_PLUGINS
                )
            ]
        ]);
    }
    // Documented in AbstractPreset
    public function managerNone() {
        return \false;
    }
    // Documented in AbstractPreset
    public function managerGtm() {
        return [
            'attributes' => [
                'codeOptInNoGoogleTagManager' => \true,
                'codeOptOutNoGoogleTagManager' => \true,
                'googleTagManagerInEventName' => 'yandex-metrica-opt-in',
                'googleTagManagerOutEventName' => 'yandex-metrica-opt-out'
            ]
        ];
    }
    // Documented in AbstractPreset
    public function managerMtm() {
        return [
            'attributes' => [
                'codeOptInNoMatomoTagManager' => \true,
                'codeOptOutNoMatomoTagManager' => \true,
                'matomoTagManagerInEventName' => 'yandex-metrica-opt-in',
                'matomoTagManagerOutEventName' => 'yandex-metrica-opt-out'
            ]
        ];
    }
}
