<?php

namespace DevOwl\RealCookieBanner\lite\presets\blocker;

use DevOwl\RealCookieBanner\comp\language\Hooks;
use DevOwl\RealCookieBanner\presets\pro\AppleMusicPreset as PresetsAppleMusicPreset;
use DevOwl\RealCookieBanner\presets\pro\blocker\AppleMusicPreset as BlockerAppleMusicPreset;
// @codeCoverageIgnoreStart
\defined('ABSPATH') or die('No script kiddies please!');
// Avoid direct file request
// @codeCoverageIgnoreEnd
/**
 * Apple Music blocker preset.
 */
class AppleMusicPreset extends \DevOwl\RealCookieBanner\presets\pro\blocker\AppleMusicPreset {
    // Documented in AbstractPreset
    public function common() {
        $parent = parent::common();
        return \array_merge($parent, [
            'attributes' => \array_merge(
                [
                    'name' => $parent['name'],
                    'description' => __(
                        'Music from Apple Music has been blocked because you did not allow to load it.',
                        \DevOwl\RealCookieBanner\comp\language\Hooks::TD_FORCED
                    ),
                    'cookies' => [\DevOwl\RealCookieBanner\presets\pro\AppleMusicPreset::IDENTIFIER],
                    'visual' => \true
                ],
                $parent['attributes']
            )
        ]);
    }
}
