<?php

namespace DevOwl\RealCookieBanner\lite\presets\blocker;

use DevOwl\RealCookieBanner\comp\language\Hooks;
use DevOwl\RealCookieBanner\presets\pro\ConvertKitPreset as PresetsConvertKitPreset;
use DevOwl\RealCookieBanner\presets\pro\blocker\ConvertKitPreset as BlockerConvertKitPreset;
// @codeCoverageIgnoreStart
\defined('ABSPATH') or die('No script kiddies please!');
// Avoid direct file request
// @codeCoverageIgnoreEnd
/**
 * ConvertKit blocker preset.
 */
class ConvertKitPreset extends \DevOwl\RealCookieBanner\presets\pro\blocker\ConvertKitPreset {
    // Documented in AbstractPreset
    public function common() {
        $parent = parent::common();
        return \array_merge($parent, [
            'attributes' => \array_merge(
                [
                    'name' => $parent['name'],
                    'description' => __(
                        'The email newsletter subscription form is blocked because you have not allowed our email marketing provider ConvertKit to load.',
                        \DevOwl\RealCookieBanner\comp\language\Hooks::TD_FORCED
                    ),
                    'cookies' => [\DevOwl\RealCookieBanner\presets\pro\ConvertKitPreset::IDENTIFIER],
                    'visual' => \true
                ],
                $parent['attributes']
            )
        ]);
    }
}
