<?php

namespace DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\Value;

use DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\Parsing\ParserState;
class URL extends \DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\Value\PrimitiveValue {
    private $oURL;
    public function __construct(\DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\Value\CSSString $oURL, $iLineNo = 0) {
        parent::__construct($iLineNo);
        $this->oURL = $oURL;
    }
    public static function parse(\DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\Parsing\ParserState $oParserState) {
        $bUseUrl = $oParserState->comes('url', \true);
        if ($bUseUrl) {
            $oParserState->consume('url');
            $oParserState->consumeWhiteSpace();
            $oParserState->consume('(');
        }
        $oParserState->consumeWhiteSpace();
        $oResult = new \DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\Value\URL(
            \DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\Value\CSSString::parse($oParserState),
            $oParserState->currentLine()
        );
        if ($bUseUrl) {
            $oParserState->consumeWhiteSpace();
            $oParserState->consume(')');
        }
        return $oResult;
    }
    public function setURL(\DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\Value\CSSString $oURL) {
        $this->oURL = $oURL;
    }
    public function getURL() {
        return $this->oURL;
    }
    public function __toString() {
        return $this->render(new \DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\OutputFormat());
    }
    public function render(\DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\OutputFormat $oOutputFormat) {
        return "url({$this->oURL->render($oOutputFormat)})";
    }
}
